/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ConstantCP
extends Constant {
    private int class_index;
    private int name_and_type_index;

    public ConstantCP(ConstantCP c) {
        this(c.getTag(), c.getClassIndex(), c.getNameAndTypeIndex());
    }

    ConstantCP(byte tag, DataInput file) throws IOException {
        this(tag, file.readUnsignedShort(), file.readUnsignedShort());
    }

    protected ConstantCP(byte tag, int class_index, int name_and_type_index) {
        super(tag);
        this.class_index = class_index;
        this.name_and_type_index = name_and_type_index;
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(super.getTag());
        file.writeShort(this.class_index);
        file.writeShort(this.name_and_type_index);
    }

    public final int getClassIndex() {
        return this.class_index;
    }

    public final void setClassIndex(int class_index) {
        this.class_index = class_index;
    }

    public final int getNameAndTypeIndex() {
        return this.name_and_type_index;
    }

    public final void setNameAndTypeIndex(int name_and_type_index) {
        this.name_and_type_index = name_and_type_index;
    }

    public String getClass(ConstantPool cp) {
        return cp.constantToString(this.class_index, (byte)7);
    }

    @Override
    public String toString() {
        return super.toString() + "(class_index = " + this.class_index + ", name_and_type_index = " + this.name_and_type_index + ")";
    }
}

