/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.converter;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyboardKeyCodeConverter {
    private static final Logger log = LoggerFactory.getLogger(KeyboardKeyCodeConverter.class);

    public static int toKeycode(KeyEvent e) {
        int k = e.keyCode;
        if (e.keyCode == 10 || e.keyCode == 13) {
            k = 13;
        } else if (e.keyCode == 27) {
            k = 27;
        } else if (e.keyCode == 0x1000002) {
            k = 258;
        } else if (e.keyCode == 0x1000001) {
            k = 259;
        } else if (e.keyCode == 0x1000003) {
            k = 260;
        } else if (e.keyCode == 0x1000004) {
            k = 261;
        } else if (e.keyCode == 0x1000008) {
            k = 360;
        } else if (e.keyCode == 0x1000007) {
            k = 262;
        } else if (e.keyCode == 0x1000006) {
            k = 338;
        } else if (e.keyCode == 0x1000005) {
            k = 339;
        } else if (e.keyCode == 127) {
            k = 330;
        } else if (e.keyCode == 0x1000009) {
            k = 331;
        } else if (e.keyCode == 8) {
            k = 8;
        } else if (e.keyCode == 9) {
            k = 9;
        } else if ((e.stateMask & 0x40000) != 0 && (e.stateMask & 0x20000) != 0) {
            if (KeyboardKeyCodeConverter.isFunctions(e)) {
                k = 301 + e.keyCode - 0x100000A;
            }
        } else if ((e.stateMask & 0x40000) != 0) {
            if (e.keyCode >= 97 && e.keyCode <= 122) {
                k = 1200 + e.keyCode - 97;
            } else if (KeyboardKeyCodeConverter.isFunctions(e)) {
                k = 289 + e.keyCode - 0x100000A;
            }
        } else if ((e.stateMask & 0x20000) != 0) {
            if (KeyboardKeyCodeConverter.isFunctions(e)) {
                k = 277 + e.keyCode - 0x100000A;
            } else if (e.keyCode >= 97 && e.keyCode <= 122) {
                k = 65 + e.keyCode - 97;
            } else if (e.keyCode >= 1072 && e.keyCode <= 1103) {
                k = e.keyCode - 32;
            } else if (e.keyCode == 1105) {
                k = 1025;
            }
        } else if ((e.stateMask & 0x10000) != 0) {
            k = e.keyCode >= 97 && e.keyCode <= 122 ? 1065 + e.keyCode - 97 : (KeyboardKeyCodeConverter.isFunctions(e) ? 313 + e.keyCode - 0x100000A : 1000 + e.keyCode);
        } else if (KeyboardKeyCodeConverter.isFunctions(e)) {
            k = 265 + e.keyCode - 0x100000A;
        }
        System.out.println(e.keyCode);
        return k;
    }

    public static KeyEvent fromKeycode(int e) {
        int swtCode = -1;
        Event event = new Event();
        Shell shell = new Shell(Display.getDefault());
        event.widget = new Text((Composite)shell, 2048);
        KeyEvent k = new KeyEvent(event);
        switch (e) {
            case 13: {
                swtCode = 13;
                break;
            }
            case 27: {
                swtCode = 27;
                break;
            }
            case 258: {
                swtCode = 0x1000002;
                break;
            }
            case 259: {
                swtCode = 0x1000001;
                break;
            }
            case 260: {
                swtCode = 0x1000003;
                break;
            }
            case 261: {
                swtCode = 0x1000004;
                break;
            }
            case 360: {
                swtCode = 0x1000008;
                break;
            }
            case 262: {
                swtCode = 0x1000007;
                break;
            }
            case 338: {
                swtCode = 0x1000006;
                break;
            }
            case 339: {
                swtCode = 0x1000005;
                break;
            }
            case 330: {
                swtCode = 127;
                break;
            }
            case 331: {
                swtCode = 0x1000009;
                break;
            }
            case 8: {
                swtCode = 8;
                break;
            }
            case 9: {
                swtCode = 9;
            }
        }
        if (swtCode == -1) {
            if (e >= 65 && e <= 90) {
                swtCode = e - 65 + 97;
                k.stateMask |= 0x20000;
            } else if (e >= 265 && e <= 276) {
                swtCode = e - 265 + 0x100000A;
            } else if (e >= 277 && e <= 288) {
                swtCode = e - 277 + 0x100000A;
                k.stateMask |= 0x20000;
            } else if (e >= 289 && e <= 300) {
                swtCode = e - 289 + 0x100000A;
                k.stateMask |= 0x40000;
            } else if (e >= 301 && e <= 312) {
                swtCode = e - 301 + 0x100000A;
                k.stateMask = k.stateMask | 0x40000 | 0x20000;
            } else if (e >= 313 && e <= 324) {
                swtCode = e - 313 + 0x100000A;
                k.stateMask |= 0x10000;
            } else if (e >= 1065 && e <= 1090) {
                swtCode = e - 1065 + 97;
                k.stateMask |= 0x10000;
            } else if (e > 1000 && e < 1065 || e > 1090 && e < 1100) {
                swtCode = e - 1000;
                k.stateMask |= 0x10000;
            } else if (e >= 1200 && e <= 1226) {
                swtCode = e - 1200 + 97;
                k.stateMask |= 0x40000;
            } else {
                swtCode = e;
            }
        }
        k.keyCode = swtCode;
        shell.dispose();
        return k;
    }

    public static String toDisplayValue(KeyEvent e) {
        int key2 = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
        KeyStroke stroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)key2);
        log.trace("mod={} key={} mod={}", new Object[]{stroke, stroke.getNaturalKey(), stroke.getModifierKeys()});
        return stroke.toString();
    }

    public static String toDisplayValue(int code) {
        return KeyboardKeyCodeConverter.toDisplayValue(KeyboardKeyCodeConverter.fromKeycode(code));
    }

    private static boolean isFunctions(KeyEvent e) {
        return e.keyCode >= 0x100000A && e.keyCode <= 0x1000015;
    }
}

