/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.editors;

import org.apache.commons.beanutils.ConstructorUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.directory.GuiActivator;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.model.UnknownTypeException;

public class DirectoryEditorFactory {
    private static final Logger log = LoggerFactory.getLogger(DirectoryEditorFactory.class);

    public static Dialog getEditor(Class<?> base, IWorkbenchWindow window, Object obj, DialogMode dialogMode) {
        return DirectoryEditorFactory.getEditor(base, window.getShell(), obj, dialogMode);
    }

    public static Dialog getEditor(Class<?> base, Shell window, Object obj, DialogMode dialogMode) {
        try {
            log.trace("get editor");
            Class<?> clazz = GuiActivator.getDefault().getCombinationService().getEditorClass(base);
            Dialog d = (Dialog)ConstructorUtils.invokeConstructor(clazz, (Object[])new Object[]{window, obj, dialogMode});
            log.trace("get editor end");
            return d;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("DirectoryEditorFactory class doesn't exist");
            throw new UnknownTypeException(obj);
        }
    }
}

