/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.provider;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.commons.beanutils.expression.Resolver;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.artixadmin.format.ArtixFormatter;
import su.artix.yuki.view.CellEditorType;
import su.artix.yuki.view.ExtendedColumn;
import su.artix.yuki.view.ImageExtractor;

public class PojoTableLabelProvider
extends StyledCellLabelProvider {
    private static final Logger log = LoggerFactory.getLogger(PojoTableLabelProvider.class);
    private List<ExtendedColumn> columns;
    private Resolver resolver = new DefaultResolver();
    private boolean globalEnable;

    public PojoTableLabelProvider(List<ExtendedColumn> columns) {
        this(columns, true);
    }

    public PojoTableLabelProvider(List<ExtendedColumn> columns, boolean globalEnable) {
        if (columns == null) {
            throw new IllegalArgumentException("Columns is null");
        }
        this.columns = columns;
        this.globalEnable = globalEnable;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int index = cell.getColumnIndex();
        Image image = this.getColumnImage(element, index);
        cell.setImage(image);
        if (image == null) {
            String columnText = this.getColumnText(element, index);
            cell.setText(columnText);
        }
        if (this.globalEnable && ArtixAdminContextHolder.isCashserver() && this.isGlobal(element)) {
            cell.setBackground(new Color(null, 0, 255, 255));
        }
        super.update(cell);
    }

    private boolean isGlobal(Object element) {
        try {
            Object obj = PropertyUtils.getProperty((Object)element, (String)"ownerStoreId");
            return StringUtils.equals((String)"$$all$$", (String)String.valueOf(obj));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = "error on extract data";
        if (element != null) {
            ExtendedColumn column = this.columns.get(columnIndex);
            String property = column.getColumnProperty();
            try {
                if (!this.resolver.hasNested(property)) {
                    result = this.getResult(element, column, property);
                } else {
                    String nested = this.resolver.next(property);
                    Object obj = PropertyUtils.getProperty((Object)element, (String)nested);
                    if (obj != null) {
                        result = this.getResult(element, column, property);
                    } else {
                        String codeProperty = String.valueOf(nested) + "code";
                        if (!PropertyUtils.isReadable((Object)element, (String)codeProperty) && !PropertyUtils.isReadable((Object)element, (String)(codeProperty = String.valueOf(nested) + "id"))) {
                            codeProperty = "id" + nested;
                        }
                        Object code = null;
                        if (PropertyUtils.isReadable((Object)element, (String)codeProperty)) {
                            code = PropertyUtils.getProperty((Object)element, (String)codeProperty);
                        }
                        result = code != null ? "<\u043e\u0431\u044a\u0435\u043a\u0442 \u0441 \u043a\u043e\u0434\u043e\u043c " + code + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d>" : "";
                    }
                }
            }
            catch (Exception e) {
                log.error(String.valueOf(e.getMessage()) + " Property:" + property, (Throwable)e);
            }
        }
        return result;
    }

    private String getResult(Object element, ExtendedColumn column, String property) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object obj = PropertyUtils.getProperty((Object)element, (String)property);
        String result = obj == null || column.getCellEditorType() == CellEditorType.BOOLEAN || column.getCellEditorType() == CellEditorType.ACTIVE ? (column.getDefaultDisplayValue() == null ? this.getNullResult() : column.getDefaultDisplayValue()) : (column.getConverter() != null ? this.converValueUseConverter(column, obj) : this.convertValueUseDefault(property, obj, column.getCellEditorType()));
        return result;
    }

    private String getNullResult() {
        return null;
    }

    private String convertValueUseDefault(String property, Object obj, CellEditorType cellEditorType) {
        String result = null;
        if (obj instanceof String) {
            result = (String)obj;
        } else if (obj instanceof Date) {
            result = ArtixFormatter.INSTANCE.timestampToString((Date)obj);
        } else if (obj instanceof Integer) {
            result = Integer.toString((Integer)obj);
        } else if (obj instanceof Long) {
            result = Long.toString((Long)obj);
        } else if (obj instanceof BigDecimal) {
            result = cellEditorType == CellEditorType.CURRENCY ? ArtixFormatter.INSTANCE.decimalToString((BigDecimal)obj, 2) : (cellEditorType == CellEditorType.QUANTITY ? ArtixFormatter.INSTANCE.decimalToString((BigDecimal)obj, 3) : ArtixFormatter.INSTANCE.decimalToString((BigDecimal)obj));
        } else if (obj instanceof Boolean) {
            result = String.valueOf(obj);
        } else if (obj instanceof BigInteger) {
            result = ArtixFormatter.INSTANCE.integerToString((BigInteger)obj);
        } else {
            log.error("Unknown value type,value={}, property={},class={}", new Object[]{obj, property, obj != null ? obj.getClass() : null});
        }
        return result;
    }

    private String converValueUseConverter(ExtendedColumn colum, Object obj) {
        String result = null;
        Object convertionResult = colum.getConverter().convert(obj);
        if (convertionResult instanceof String) {
            result = (String)convertionResult;
        } else {
            log.error("Bad result of conversion object:{},result:{},column:{}", new Object[]{obj, convertionResult, colum});
        }
        return result;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ExtendedColumn column = this.columns.get(columnIndex);
        String property = column.getColumnProperty();
        ImageExtractor<?> imageExtractor = column.getImageExtractor();
        if (imageExtractor != null) {
            try {
                Object obj = PropertyUtils.getProperty((Object)element, (String)property);
                return imageExtractor.getImage(obj);
            }
            catch (Exception e) {
                log.error(String.valueOf(e.getMessage()) + " Property: " + property, (Throwable)e);
            }
        }
        return null;
    }
}

