/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.view;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.yuki.view.ImageExtractor;

public class Base64ImageExtractor
implements ImageExtractor<String> {
    private static final Logger log = LoggerFactory.getLogger(Base64ImageExtractor.class);

    @Override
    public Image getImage(String imageData) {
        return this.getImage(imageData, 250, 140);
    }

    public Image getImage(String imageData, int width, int height) {
        if (imageData != null && !StringUtils.isEmpty((String)imageData)) {
            try {
                ImageData imgData = new ImageData((InputStream)new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)imageData)));
                Image image = new Image((Device)Display.getDefault(), imgData);
                return Base64ImageExtractor.resize(image, width, height);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static Image resize(Image image, int width, int height) {
        Image scaled = new Image((Device)Display.getDefault(), width, height);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        float ratio = Math.min((float)width * 1.0f / (float)image.getBounds().width, (float)height * 1.0f / (float)image.getBounds().height);
        int widthA = (int)(ratio * (float)image.getBounds().width);
        int heightA = (int)(ratio * (float)image.getBounds().height);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, widthA, heightA);
        gc.dispose();
        image.dispose();
        return scaled;
    }
}

