/*
 * Decompiled with CFR 0.152.
 */
package su.artix.accounting.rpc.logic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.accounting.rpc.logic.LocationNotFound;

public abstract class AbstractAccountingClient<C>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractAccountingClient.class);
    private List<String> locations = new ArrayList<String>();
    private boolean locationDisposed = true;
    private int currentPort;
    private String currentHost;
    private int currentTimeout = 0;
    private static final int DEFAULT_TIMEOUT = 0;
    private String idServer = "default";
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdServer() {
        return this.idServer;
    }

    public void setIdServer(String idServer) {
        this.idServer = idServer;
    }

    private Object doWork(Work<C> work, String host, int port, int timeout) {
        Object result = null;
        try {
            log.trace("Open connection on {}:{} timeout={}", new Object[]{host, port, timeout});
            TSocket transport = new TSocket(host, port, timeout);
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            C client = this.getClient((TProtocol)protocol);
            transport.open();
            result = work.doIt(client);
            transport.close();
            log.trace("Close connection");
        }
        catch (TTransportException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.locationDisposed = true;
        }
        catch (TException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.locationDisposed = true;
        }
        return result;
    }

    protected abstract C getClient(TProtocol var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doWork(Work<C> work) throws LocationNotFound {
        AbstractAccountingClient abstractAccountingClient = this;
        synchronized (abstractAccountingClient) {
            if (this.locationDisposed) {
                this.findLocation();
                if (this.locationDisposed) {
                    throw new LocationNotFound();
                }
            }
        }
        return this.doWork(work, this.currentHost, this.currentPort, this.currentTimeout);
    }

    public boolean findLocation() {
        String host = null;
        int port = 0;
        int timeout = 0;
        for (String location : this.locations) {
            String[] sp = location.split(":");
            host = sp[0];
            if (!AbstractAccountingClient.isGoodLocation(host, port = Integer.parseInt(sp[1]), timeout = sp.length > 2 ? Integer.parseInt(sp[2]) : 0)) continue;
            this.locationDisposed = false;
            break;
        }
        if (!this.locationDisposed) {
            this.currentHost = host;
            this.currentPort = port;
            this.currentTimeout = timeout;
        }
        return this.locationDisposed;
    }

    private static boolean isGoodLocation(String host, int port, int timeout) {
        boolean goodLocation = false;
        try {
            TSocket transport = new TSocket(host, port, timeout);
            transport.open();
            transport.close();
            goodLocation = true;
        }
        catch (TTransportException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.trace("Check location on {}:{}. Result={} ", new Object[]{host, port, goodLocation});
        return goodLocation;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public int getCurrentPort() {
        return this.currentPort;
    }

    public void setCurrentPort(int currentPort) {
        this.currentPort = currentPort;
    }

    public static interface Work<L> {
        public Object doIt(L var1) throws TException;
    }
}

