/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.cashtree.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import su.artix.cashserver.cashtree.domain.Shop;
import su.artix.cashserver.cashtree.domain.Tag;
import su.artix.cashserver.cashtree.domain.TagType;
import su.artix.cashserver.cashtree.filter.ShopFilter;

public class ShopFilterImpl
extends ViewerFilter
implements ShopFilter {
    private String searchString = null;
    private List<Tag> searchTags;

    @Override
    public void setSearchText(String s) {
        this.searchString = s;
    }

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof Shop) {
            Shop shop = (Shop)element;
            return this.visibleShopByName(shop) && this.visibleShopByTags(shop);
        }
        return true;
    }

    private boolean visibleShopByName(Shop shop) {
        if (this.searchString == null || this.searchString.length() == 0) {
            return true;
        }
        return StringUtils.containsIgnoreCase((String)shop.getTitle(), (String)this.searchString);
    }

    private boolean visibleShopByTags(Shop shop) {
        if (this.searchTags == null || this.searchTags.isEmpty()) {
            return true;
        }
        return this.searchTag(shop.getTags());
    }

    @Override
    public void setSearchTags(List<Tag> tags) {
        this.searchTags = tags;
    }

    private boolean searchTag(List<Tag> shopTags) {
        ArrayList<TagType> tagTypes = new ArrayList<TagType>();
        for (Tag searchTag : this.searchTags) {
            boolean isExist = false;
            for (TagType tagType : tagTypes) {
                if (!tagType.equals((Object)searchTag.getTagType())) continue;
                isExist = true;
            }
            if (isExist) continue;
            tagTypes.add(searchTag.getTagType());
        }
        ArrayList<TagType> findTagTypes = new ArrayList<TagType>();
        for (Tag shopTag : shopTags) {
            for (Tag searchTag : this.searchTags) {
                if (!shopTag.equals((Object)searchTag)) continue;
                findTagTypes.remove(searchTag.getTagType());
                findTagTypes.add(searchTag.getTagType());
            }
        }
        tagTypes.removeAll(findTagTypes);
        return tagTypes.isEmpty();
    }
}

