/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.lazy;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.EntitiesConfigurations;
import org.hibernate.envers.entities.EntityConfiguration;
import org.hibernate.envers.entities.mapper.relation.lazy.AbstractDelegateSessionImplementor;
import org.hibernate.envers.reader.AuditReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToOneDelegateSessionImplementor
extends AbstractDelegateSessionImplementor {
    private static final long serialVersionUID = 4770438372940785488L;
    private final AuditReaderImplementor versionsReader;
    private final Class<?> entityClass;
    private final Object entityId;
    private final Number revision;
    private EntityConfiguration notVersionedEntityConfiguration;

    public ToOneDelegateSessionImplementor(AuditReaderImplementor versionsReader, Class<?> entityClass, Object entityId, Number revision, AuditConfiguration verCfg) {
        super(versionsReader.getSessionImplementor());
        this.versionsReader = versionsReader;
        this.entityClass = entityClass;
        this.entityId = entityId;
        this.revision = revision;
        EntitiesConfigurations entCfg = verCfg.getEntCfg();
        this.notVersionedEntityConfiguration = entCfg.getNotVersionEntityConfiguration(entityClass.getName());
    }

    @Override
    public Object doImmediateLoad(String entityName) throws HibernateException {
        if (this.notVersionedEntityConfiguration == null) {
            return this.versionsReader.find(this.entityClass, this.entityId, this.revision);
        }
        return this.delegate.immediateLoad(entityName, (Serializable)this.entityId);
    }
}

