/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.SystemTitleAreaDialog;
import su.artix.discountmanager.dialogs.discountsystem.DiscountConditionConstructorPanel;
import su.artix.discountmanager.utils.QuestionMessageFactory;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.yuki.discount.condition.constructor.dao.ConstructorTreeProcessor;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplate;
import su.artix.yuki.discount.condition.template.dao.ConditionTemplateDAO;
import su.artix.yuki.editors.DialogMode;

public class DiscountConditionConstructorDialog
extends SystemTitleAreaDialog {
    private static final String TITLE_AREA_TEXT_ADD = "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0443\u0441\u043b\u043e\u0432\u0438\u0435";
    private static final String TITLE_AREA_MESSAGE_ADD = "\u0423\u0441\u043b\u043e\u0432\u0438\u0435 \u043c\u043e\u0436\u043d\u043e c\u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440\u0430(\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f) \u0438\u043b\u0438 \u0432\u0432\u0435\u0441\u0442\u0438 \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0432 \u043f\u043e\u043b\u0435 \"\u0423\u0441\u043b\u043e\u0432\u0438\u0435\"";
    private static final String TITLE_AREA_TEXT = "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0443\u0441\u043b\u043e\u0432\u0438\u0435";
    private static final String TITLE_AREA_MESSAGE = "\u0423\u0441\u043b\u043e\u0432\u0438\u0435 \u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440\u0430(\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f) \u0438\u043b\u0438 \u0432\u0440\u0443\u0447\u043d\u0443\u044e";
    private final int SAVE_TEMPLATE_BTN_NUMBER = 3;
    private DiscountConditionConstructorPanel panel;
    private Discount discount;
    private DiscountCondition condition;
    private ConstructorTreeProcessor treeProcessor;
    private ConditionTemplateDAO conditionTemplatesDAO;
    private String title;
    private boolean confirmCancel;

    public DiscountConditionConstructorDialog(Discount discount, DiscountCondition condition, ConstructorTreeProcessor treeProcessor, ConditionTemplateDAO templateDAO) {
        super(Display.getCurrent().getActiveShell(), DialogMode.UPDATE, null);
        this.init(discount, treeProcessor, templateDAO, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f");
        this.condition = condition;
    }

    public DiscountConditionConstructorDialog(Discount discount, ConstructorTreeProcessor treeProcessor, ConditionTemplateDAO templateDAO) {
        super(Display.getCurrent().getActiveShell(), DialogMode.CREATE, null);
        this.init(discount, treeProcessor, templateDAO, "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f");
    }

    private void init(Discount discount, ConstructorTreeProcessor treeProcessor, ConditionTemplateDAO templateDAO, String shellTitle) {
        this.discount = discount;
        this.conditionTemplatesDAO = templateDAO;
        this.treeProcessor = treeProcessor;
        this.title = shellTitle;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.confirmCancel = preferenceStore.getBoolean("CONFIRM_CANCEL_FOR_COMPLEX_DIALOG");
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(500, 480);
        newShell.setText(this.title);
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        if (DialogMode.CREATE == this.getDialogMode()) {
            this.setTitle(TITLE_AREA_TEXT_ADD);
            this.setMessage(TITLE_AREA_MESSAGE_ADD);
        } else {
            this.setTitle(TITLE_AREA_TEXT);
            this.setMessage(TITLE_AREA_MESSAGE);
        }
        Composite dialogPanel = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(dialogPanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dialogPanel);
        this.panel = new DiscountConditionConstructorPanel(dialogPanel, 0, this.discount, this.condition, this.treeProcessor);
        this.panel.setEnableButtons(new Action(){

            public void run() {
                DiscountConditionConstructorDialog.this.getButton(0).setEnabled(true);
                DiscountConditionConstructorDialog.this.getButton(3).setEnabled(DiscountConditionConstructorDialog.this.conditionTemplatesDAO != null);
            }
        });
        this.panel.setDisableButtons(new Action(){

            public void run() {
                DiscountConditionConstructorDialog.this.getButton(0).setEnabled(false);
                DiscountConditionConstructorDialog.this.getButton(3).setEnabled(false);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.panel);
        return dialogPanel;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        GridDataFactory.fillDefaults().grab(true, false).align(131072, 1024).applyTo((Control)parent);
        this.createButton(parent, 3, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432 \u0448\u0430\u0431\u043b\u043e\u043d", false);
        String btnStr = "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c";
        if (DialogMode.CREATE != this.getDialogMode()) {
            btnStr = "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c";
        }
        this.createButton(parent, 0, btnStr, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        if (DialogMode.CREATE == this.getDialogMode()) {
            this.getButton(3).setEnabled(false);
            this.getButton(0).setEnabled(false);
        }
        if (this.conditionTemplatesDAO == null) {
            this.getButton(3).setEnabled(false);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 3) {
            this.saveToTemplate();
            MessageDialog.openInformation((Shell)this.getShell(), (String)"\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e", (String)"\u0428\u0430\u0431\u043b\u043e\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d");
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        if (this.panel.okPressed()) {
            this.condition = this.panel.getDiscountCondition();
            for (DiscountCondition cond : this.discount.getDiscountConditions()) {
                if (!this.condition.equalsWithoutParent((Object)cond.getCondition())) continue;
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430!", (String)"\u0422\u0430\u043a\u043e\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u0443\u0436\u0435 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u043a\u0438\u0434\u043a\u0435!");
                return;
            }
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        if (this.confirmCancel && this.panel.isChanged()) {
            if (QuestionMessageFactory.cancelQuestionMessage()) {
                super.cancelPressed();
            }
        } else {
            super.cancelPressed();
        }
    }

    private void saveToTemplate() {
        ConditionTemplate template = this.panel.getTemplate();
        if (this.conditionTemplatesDAO != null) {
            this.conditionTemplatesDAO.addTemplate(template);
        }
    }

    public DiscountCondition getDiscountCondition() {
        return this.condition;
    }
}

