/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.cashadmin.domain.Client;
import ru.ssa.cashadmin.domain.ClientAdditionalInfo;
import ru.ssa.cashadmin.domain.ClientServerV144;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.artixadmin.connection.ArtixAdminContextHolder;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.yuki.action.DirectoryRemoveAction;
import su.artix.yuki.model.ModelActivator;

public class DeleteClientAction
extends DirectoryRemoveAction<Client> {
    private static final Logger log = LoggerFactory.getLogger(DeleteClientAction.class);

    public DeleteClientAction() {
        super(Client.class);
    }

    public void run() {
        ISelection selection = this.window.getSelectionService().getSelection();
        log.trace("selection {}", (Object)selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            try {
                if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", (String)"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432?")) {
                    IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
                    boolean useClientAdditionalInfo = preferenceStore.getBoolean("CLIENT_ADDITIONAL_INFO_INSTEAD_TEXT");
                    for (Object obj : structuredSelection.toList()) {
                        Client client = (Client)obj;
                        this.delete(client, useClientAdditionalInfo);
                    }
                }
                ModelActivator.getDefault().getModelProvider().getDirectoryModel(this.getClazz()).doRefresh();
            }
            catch (ExecuteQueryException e) {
                log.error(e.getMessage(), (Throwable)e);
                ErrorMessageFactory.exceptionMessage(e);
            }
        }
    }

    private void delete(Client client, boolean useClientAdditionalInfo) throws ExecuteQueryException {
        ClientAdditionalInfo clientAdditionalInfo = null;
        if (useClientAdditionalInfo && ArtixAdminContextHolder.isCashserver() && client != null && ClientServerV144.class.isAssignableFrom(client.getClass())) {
            clientAdditionalInfo = ((ClientServerV144)client).getClientAdditionalInfo();
        }
        ModelActivator.getDefault().getModelProvider().getDirectoryModel(Client.class).delete((Object)client);
        if (clientAdditionalInfo != null) {
            ModelActivator.getDefault().getModelProvider().getDirectoryModel(ClientAdditionalInfo.class).delete((Object)clientAdditionalInfo);
        }
    }
}

