/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTypeHolder {
    private static final Set<Class<?>> DEFAULTS = new HashSet();
    private final Set<Class<?>> simpleTypes;

    public SimpleTypeHolder() {
        this(Collections.EMPTY_SET, true);
    }

    public SimpleTypeHolder(Set<? extends Class<?>> customSimpleTypes, boolean registerDefaults) {
        Assert.notNull(customSimpleTypes);
        this.simpleTypes = new HashSet(customSimpleTypes);
        if (registerDefaults) {
            this.simpleTypes.addAll(DEFAULTS);
        }
    }

    public SimpleTypeHolder(Set<? extends Class<?>> customSimpleTypes, SimpleTypeHolder source) {
        Assert.notNull(customSimpleTypes);
        Assert.notNull((Object)source);
        this.simpleTypes = new HashSet(customSimpleTypes);
        this.simpleTypes.addAll(source.simpleTypes);
    }

    public boolean isSimpleType(Class<?> type) {
        Assert.notNull(type);
        if (Object.class.equals(type)) {
            return true;
        }
        for (Class<?> clazz : this.simpleTypes) {
            if (type != clazz && !clazz.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    static {
        DEFAULTS.add(Boolean.TYPE);
        DEFAULTS.add(boolean[].class);
        DEFAULTS.add(Long.TYPE);
        DEFAULTS.add(long[].class);
        DEFAULTS.add(Short.TYPE);
        DEFAULTS.add(short[].class);
        DEFAULTS.add(Integer.TYPE);
        DEFAULTS.add(int[].class);
        DEFAULTS.add(Byte.TYPE);
        DEFAULTS.add(byte[].class);
        DEFAULTS.add(Float.TYPE);
        DEFAULTS.add(float[].class);
        DEFAULTS.add(Double.TYPE);
        DEFAULTS.add(double[].class);
        DEFAULTS.add(Character.TYPE);
        DEFAULTS.add(char[].class);
        DEFAULTS.add(Boolean.class);
        DEFAULTS.add(Long.class);
        DEFAULTS.add(Short.class);
        DEFAULTS.add(Integer.class);
        DEFAULTS.add(Byte.class);
        DEFAULTS.add(Float.class);
        DEFAULTS.add(Double.class);
        DEFAULTS.add(Character.class);
        DEFAULTS.add(String.class);
        DEFAULTS.add(Date.class);
        DEFAULTS.add(Locale.class);
        DEFAULTS.add(Class.class);
        DEFAULTS.add(Enum.class);
    }
}

