/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.DefaultRepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryConfigurationExtensionSupport
implements RepositoryConfigurationExtension {
    protected static final String REPOSITORY_INTERFACE_POST_PROCESSOR = "org.springframework.data.repository.core.support.RepositoryInterfaceAwareBeanPostProcessor";

    @Override
    public <T extends RepositoryConfigurationSource> Collection<RepositoryConfiguration<T>> getRepositoryConfigurations(T configSource, ResourceLoader loader) {
        Assert.notNull(configSource);
        Assert.notNull((Object)loader);
        HashSet<RepositoryConfiguration<T>> result = new HashSet<RepositoryConfiguration<T>>();
        for (String candidate : configSource.getCandidates(loader)) {
            result.add(this.getRepositoryConfiguration(candidate, configSource));
        }
        return result;
    }

    @Override
    public String getDefaultNamedQueryLocation() {
        return String.format("classpath*:META-INF/%s-named-queries.properties", this.getModulePrefix());
    }

    @Override
    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        AbstractBeanDefinition definition = BeanDefinitionBuilder.rootBeanDefinition((String)REPOSITORY_INTERFACE_POST_PROCESSOR).getBeanDefinition();
        RepositoryConfigurationExtensionSupport.registerWithSourceAndGeneratedBeanName(registry, definition, configurationSource.getSource());
    }

    protected abstract String getModulePrefix();

    @Override
    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
    }

    public static String registerWithSourceAndGeneratedBeanName(BeanDefinitionRegistry registry, AbstractBeanDefinition bean, Object source) {
        bean.setSource(source);
        String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)bean, (BeanDefinitionRegistry)registry);
        registry.registerBeanDefinition(beanName, (BeanDefinition)bean);
        return beanName;
    }

    public static boolean hasBean(Class<?> type, BeanDefinitionRegistry registry) {
        String name = String.format("%s%s0", type.getName(), "#");
        return registry.containsBeanDefinition(name);
    }

    protected <T extends RepositoryConfigurationSource> RepositoryConfiguration<T> getRepositoryConfiguration(String interfaceName, T configSource) {
        return new DefaultRepositoryConfiguration<T>(configSource, interfaceName);
    }
}

