/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.discount.condition.domain.xml;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import su.artix.yuki.discount.condition.domain.xml.ConditionTemplateValue;
import su.artix.yuki.discount.condition.domain.xml.ConditionType;
import su.artix.yuki.discount.condition.domain.xml.DiscountObjectType;

@XmlType(propOrder={"specification", "definition", "values", "discountTypes", "tags", "order"})
public class ConditionTemplate {
    private Integer order;
    private List<String> tags;
    private List<DiscountObjectType> discountTypes;
    private String specification;
    private String definition;
    private List<ConditionTemplateValue> values;
    private ConditionType type;

    @XmlAttribute
    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    @XmlAttribute(name="tag")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        if (tag != null && !tag.isEmpty() && !this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    @XmlAttribute(name="type")
    public List<DiscountObjectType> getDiscountTypes() {
        return this.discountTypes;
    }

    public void setDiscountTypes(List<DiscountObjectType> discountTypes) {
        this.discountTypes = discountTypes;
    }

    public void addDiscountType(DiscountObjectType discountType) {
        if (this.discountTypes == null) {
            this.discountTypes = new ArrayList<DiscountObjectType>();
        }
        if (discountType != null && !this.discountTypes.contains((Object)discountType)) {
            this.discountTypes.add(discountType);
        }
    }

    @XmlElement(name="specification")
    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    @XmlElement(name="definition")
    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    @XmlTransient
    public ConditionType getType() {
        return this.type;
    }

    public void setType(ConditionType type) {
        this.type = type;
    }

    @XmlElementWrapper(name="values")
    @XmlElement(name="value")
    public List<ConditionTemplateValue> getValues() {
        return this.values;
    }

    public void setValues(List<ConditionTemplateValue> values) {
        this.values = values;
    }

    public ConditionTemplate copy() {
        ConditionTemplate template = new ConditionTemplate();
        template.setSpecification(this.specification);
        template.setDefinition(this.definition);
        LinkedList<ConditionTemplateValue> list = new LinkedList<ConditionTemplateValue>();
        if (this.values != null) {
            for (ConditionTemplateValue value : this.values) {
                list.add(new ConditionTemplateValue(value.getLabel(), value.getType(), value.getDefaultValue()));
            }
        }
        template.setValues(list);
        template.setType(this.type);
        return template;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.discountTypes == null ? 0 : this.discountTypes.hashCode());
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.order == null ? 0 : this.order.hashCode());
        result = 31 * result + (this.specification == null ? 0 : this.specification.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionTemplate other = (ConditionTemplate)obj;
        if (this.order == null ? other.order != null : !this.order.equals(other.order)) {
            return false;
        }
        if (this.discountTypes == null ? other.discountTypes != null : !this.discountTypes.equals(other.discountTypes)) {
            return false;
        }
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        if (this.specification == null ? other.specification != null : !this.specification.equals(other.specification)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConditionTemplate [order=");
        builder.append(this.order);
        builder.append(", tags=");
        builder.append(this.tags);
        builder.append(", discountTypes=");
        builder.append(this.discountTypes);
        builder.append(", specification=");
        builder.append(this.specification);
        builder.append(", definition=");
        builder.append(this.definition);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append("]");
        return builder.toString();
    }
}

