/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ganttchart;

import org.eclipse.nebula.widgets.ganttchart.GanttChart;
import org.eclipse.nebula.widgets.ganttchart.GanttComposite;
import org.eclipse.nebula.widgets.ganttchart.GanttEvent;
import org.eclipse.swt.graphics.Color;

public class GanttConnection
implements Cloneable {
    private GanttEvent _source;
    private GanttEvent _target;
    private Color _color;
    private GanttComposite _parent;

    GanttConnection() {
    }

    GanttConnection(GanttEvent source, GanttEvent target, Color color) {
        this(null, source, target, color);
    }

    public GanttConnection(GanttChart parent, GanttEvent source, GanttEvent target) {
        this(parent, source, target, null);
    }

    public GanttConnection(GanttChart parent, GanttEvent source, GanttEvent target, Color lineColor) {
        this._source = source;
        this._target = target;
        this._color = lineColor;
        if (parent != null) {
            this._parent = parent.getGanttComposite();
            this._parent.connectionAdded(this);
        }
    }

    public GanttEvent getSource() {
        return this._source;
    }

    public void setSource(GanttEvent source) {
        this._source = source;
    }

    public GanttEvent getTarget() {
        return this._target;
    }

    public void setTarget(GanttEvent target) {
        this._target = target;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public void dispose() {
        this._parent.connectionRemoved(this);
    }

    public Object clone() throws CloneNotSupportedException {
        GanttConnection clone = new GanttConnection();
        clone._parent = this._parent;
        clone._color = this._color;
        clone._source = this._source;
        clone._target = this._target;
        this._parent.connectionAdded(clone);
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GanttConnection other = (GanttConnection)obj;
        if (this._source == null ? other._source != null : !this._source.equals(other._source)) {
            return false;
        }
        return !(this._target == null ? other._target != null : !this._target.equals(other._target));
    }
}

