/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.cashtree.model.httpclient;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import su.artix.cashserver.cashtree.domain.Category;
import su.artix.cashserver.cashtree.domain.Group;
import su.artix.cashserver.cashtree.domain.MiddleServer;
import su.artix.cashserver.cashtree.domain.Node;
import su.artix.cashserver.cashtree.domain.Shop;
import su.artix.cashserver.cashtree.domain.converter.DomainConverter;
import su.artix.cashserver.cashtree.model.AbstractTreeModel;
import su.artix.cashserver.core.cashregistry.repository.GroupRepository;
import su.artix.cashserver.core.cashregistry.repository.ShopRepository;

public class TreeModelHttpClient
extends AbstractTreeModel {
    private static final Logger log = LoggerFactory.getLogger(TreeModelHttpClient.class);
    @Autowired
    private DomainConverter domainConverter;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private ShopRepository shopRepository;

    private Group richGroup(Group group) {
        if (group.getGroups() == null) {
            ArrayList<String> groupIds = new ArrayList<String>();
            for (su.artix.cashserver.core.cashregistry.domain.Group child : this.groupRepository.findByParentCode(group.getId())) {
                groupIds.add(child.getStoreId());
            }
            group.setGroups(groupIds);
        }
        if (group.getShops() == null) {
            ArrayList<String> shopIds = new ArrayList<String>();
            for (su.artix.cashserver.core.cashregistry.domain.Group child : this.shopRepository.findByParentCode(group.getId())) {
                shopIds.add(child.getCode());
            }
            group.setShops(shopIds);
        }
        return group;
    }

    public List<Node> getRoots(String clusterId) {
        ArrayList<Node> roots = new ArrayList<Node>();
        roots.addAll(this.getRootGroups(clusterId));
        roots.addAll(this.getRootShops(clusterId));
        return roots;
    }

    public List<Group> getRootGroups(String clusterId) {
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            for (su.artix.cashserver.core.cashregistry.domain.Group group : this.groupRepository.findRootGroups()) {
                if (!StringUtils.isEmpty((String)clusterId) && !StringUtils.isEmpty((String)group.getClusterId()) && !clusterId.equals(group.getClusterId())) continue;
                groups.add(this.richGroup((Group)this.domainConverter.convert((Object)group, Group.class)));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    public List<Shop> getRootShops(String clusterId) {
        ArrayList<Shop> shops = new ArrayList<Shop>();
        try {
            for (su.artix.cashserver.core.cashregistry.domain.Shop shop : this.shopRepository.findAll()) {
                if (shop.getParent() != null || !StringUtils.isEmpty((String)clusterId) && !clusterId.equals(shop.getClusterId())) continue;
                shops.add((Shop)this.domainConverter.convert((Object)shop, Shop.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return shops;
    }

    public List<Group> getGroups() {
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            for (su.artix.cashserver.core.cashregistry.domain.Group group : this.groupRepository.findAll()) {
                groups.add(this.richGroup((Group)this.domainConverter.convert((Object)group, Group.class)));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    public List<MiddleServer> getMiddleServers() {
        return Collections.emptyList();
    }

    public List<Shop> getShops() {
        ArrayList<Shop> shops = new ArrayList<Shop>();
        try {
            for (su.artix.cashserver.core.cashregistry.domain.Shop shop : this.shopRepository.findAll()) {
                shops.add((Shop)this.domainConverter.convert((Object)shop, Shop.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return shops;
    }

    public List<Group> getGroupsByParentCode(String clusterId, String code) {
        if (StringUtils.isEmpty((String)code)) {
            return Collections.emptyList();
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            for (su.artix.cashserver.core.cashregistry.domain.Group group : this.groupRepository.findByParentCode(code)) {
                if (!StringUtils.isEmpty((String)clusterId) && !clusterId.equals(group.getClusterId())) continue;
                groups.add(this.richGroup((Group)this.domainConverter.convert((Object)group, Group.class)));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return groups;
    }

    public List<MiddleServer> getMiddleServersByParentCode(String clusterId, String code) {
        return Collections.emptyList();
    }

    public List<Shop> getShopsByParentCode(String clusterId, String code) {
        if (StringUtils.isEmpty((String)code)) {
            return Collections.emptyList();
        }
        ArrayList<Shop> shops = new ArrayList<Shop>();
        try {
            for (su.artix.cashserver.core.cashregistry.domain.Shop shop : this.shopRepository.findByParentCode(code)) {
                if (!StringUtils.isEmpty((String)clusterId) && !clusterId.equals(shop.getClusterId())) continue;
                shops.add((Shop)this.domainConverter.convert((Object)shop, Shop.class));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return shops;
    }

    public List<Category> getCategoriesByParentCode(String clusterId, String code) {
        return Collections.emptyList();
    }
}

