/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.gradientComposite;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class GradientComposite
extends Composite {
    private Image previousGeneratedImage;
    private Color gradientEnd;
    private Color gradientStart;

    public GradientComposite(Composite composite, int n) {
        super(composite, n);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GradientComposite.this.redrawComposite();
            }
        });
        this.gradientStart = this.getDisplay().getSystemColor(2);
        this.gradientEnd = SWTGraphicUtil.getDefaultColor((Control)this, 110, 110, 110);
    }

    private void redrawComposite() {
        Display display = this.getDisplay();
        Rectangle rectangle = this.getClientArea();
        Image image = new Image((Device)display, Math.max(1, rectangle.width), Math.max(1, rectangle.height));
        GC gC = new GC((Drawable)image);
        gC.setForeground(this.gradientStart);
        gC.setBackground(this.gradientEnd);
        gC.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height / 2, true);
        gC.setForeground(this.gradientEnd);
        gC.setBackground(this.gradientStart);
        gC.fillGradientRectangle(rectangle.x, rectangle.height / 2, rectangle.width, rectangle.height / 2, true);
        gC.dispose();
        this.setBackgroundImage(image);
        if (this.previousGeneratedImage != null) {
            this.previousGeneratedImage.dispose();
        }
        this.previousGeneratedImage = image;
    }

    public Color getGradientEnd() {
        return this.gradientEnd;
    }

    public void setGradientEnd(Color color) {
        this.gradientEnd = color;
    }

    public Color getGradientStart() {
        return this.gradientStart;
    }

    public void setGradientStart(Color color) {
        this.gradientStart = color;
    }
}

