/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.mihalis.opal.preferenceWindow.PWContainer;
import org.mihalis.opal.preferenceWindow.PWRow;
import org.mihalis.opal.preferenceWindow.PWRowGroup;
import org.mihalis.opal.preferenceWindow.PWTab;
import org.mihalis.opal.preferenceWindow.widgets.PWWidget;

public class PWGroup
extends PWRowGroup {
    private final String label;
    private final boolean hasBorder;
    private final List<PWRow> children;

    public PWGroup(boolean bl) {
        this(null, bl);
    }

    public PWGroup(String string) {
        this(string, true);
    }

    public PWGroup(String string, boolean bl) {
        this.label = string;
        this.hasBorder = bl;
        this.children = new ArrayList<PWRow>();
    }

    @Override
    public PWContainer add(PWContainer pWContainer) {
        if (!(pWContainer instanceof PWRow)) {
            throw new UnsupportedOperationException("Can only add a PWRow.");
        }
        this.children.add((PWRow)pWContainer);
        return this;
    }

    @Override
    public PWContainer add(PWWidget pWWidget) {
        PWRow pWRow = new PWRow();
        pWRow.add(pWWidget);
        this.children.add(pWRow);
        return this;
    }

    @Override
    public void build(Composite composite) {
        Group group;
        if (this.hasBorder) {
            group = new Group(composite, 0);
            if (this.label != null && !this.label.trim().equals("")) {
                group.setText(this.label);
            }
        } else {
            group = new Composite(composite, 2048);
        }
        int n = this.computeNumberOfColumns();
        group.setLayout((Layout)new GridLayout(n, false));
        group.setLayoutData((Object)new GridData(1, 4, false, false, this.parentNumberOfColums, 1));
        for (PWRow pWRow : this.children) {
            pWRow.setParentNumberOfColumns(n);
            pWRow.build((Composite)group);
        }
    }

    private int computeNumberOfColumns() {
        int n = 1;
        for (PWRow pWRow : this.children) {
            n = Math.max(n, pWRow.getNumberOfColums());
        }
        return n;
    }

    @Override
    protected void checkParent(PWContainer pWContainer) {
        if (pWContainer instanceof PWTab) {
            return;
        }
        throw new UnsupportedOperationException("Bad parent, should be only PWTab ");
    }

    @Override
    public void enableOrDisable() {
        if (this.enabler == null) {
            return;
        }
        boolean bl = this.enabler.isEnabled();
        for (PWRow pWRow : this.children) {
            this.enableOrDisable(pWRow, bl);
        }
    }

    private void enableOrDisable(PWRow pWRow, boolean bl) {
        for (PWWidget pWWidget : pWRow.widgets) {
            boolean bl2 = pWWidget.enableOrDisable();
            for (Control control : pWWidget.getControls()) {
                if (control.isDisposed()) continue;
                control.setEnabled(bl && bl2);
            }
        }
    }
}

