/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.starRating;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.mihalis.opal.starRating.StarRating;

class Star {
    private static final String SMALL_STAR_MARKED_FOCUS = "mark-focus16.png";
    private static final String SMALL_STAR_MARKED = "mark16.png";
    private static final String SMALL_STAR_FOCUS = "focus16.png";
    private static final String SMALL_STAR = "16.png";
    private static final String BIG_STAR_MARKED_FOCUS = "mark-focus32.png";
    private static final String BIG_STAR_MARKED = "mark32.png";
    private static final String BIG_STAR_FOCUS = "focus32.png";
    private static final String BIG_STAR = "32.png";
    boolean hover;
    boolean marked;
    Rectangle bounds;
    Image defaultImage;
    Image hoverImage;
    Image selectedImage;
    Image selectedHoverImage;
    private StarRating parent;

    Star() {
    }

    void dispose() {
        this.defaultImage.dispose();
        this.hoverImage.dispose();
        this.selectedImage.dispose();
        this.selectedHoverImage.dispose();
    }

    void draw(GC gC, int n, int n2) {
        Image image = !this.parent.isEnabled() ? this.defaultImage : (this.marked ? (this.hover ? this.selectedHoverImage : this.selectedImage) : (this.hover ? this.hoverImage : this.defaultImage));
        gC.drawImage(image, n, n2);
        this.bounds = new Rectangle(n, n2, image.getBounds().width, image.getBounds().height);
    }

    static Star initBig(StarRating starRating) {
        Star star = new Star();
        star.parent = starRating;
        star.defaultImage = new Image((Device)Display.getCurrent(), star.getClass().getClassLoader().getResourceAsStream("images/stars/32.png"));
        star.hoverImage = new Image((Device)Display.getCurrent(), star.getClass().getClassLoader().getResourceAsStream("images/stars/focus32.png"));
        star.selectedImage = new Image((Device)Display.getCurrent(), star.getClass().getClassLoader().getResourceAsStream("images/stars/mark32.png"));
        star.selectedHoverImage = new Image((Device)Display.getCurrent(), star.getClass().getClassLoader().getResourceAsStream("images/stars/mark-focus32.png"));
        return star;
    }

    static Star initSmall(StarRating starRating) {
        Star star = new Star();
        star.parent = starRating;
        star.defaultImage = new Image((Device)Display.getCurrent(), star.getClass().getClassLoader().getResourceAsStream("images/stars/16.png"));
        star.hoverImage = new Image((Device)Display.getCurrent(), star.getClass().getClassLoader().getResourceAsStream("images/stars/focus16.png"));
        star.selectedImage = new Image((Device)Display.getCurrent(), star.getClass().getClassLoader().getResourceAsStream("images/stars/mark16.png"));
        star.selectedHoverImage = new Image((Device)Display.getCurrent(), star.getClass().getClassLoader().getResourceAsStream("images/stars/mark-focus16.png"));
        return star;
    }
}

