/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.systemMonitor;

import org.eclipse.swt.graphics.RGB;
import org.mihalis.opal.systemMonitor.CPUUsageSample;
import org.mihalis.opal.systemMonitor.HeapMemorySample;
import org.mihalis.opal.systemMonitor.PhysicalMemorySample;
import org.mihalis.opal.systemMonitor.SampleIdentifier;
import org.mihalis.opal.systemMonitor.SampleWrapper;
import org.mihalis.opal.systemMonitor.ThreadsUsageSample;

public class SampleFactory {
    private static SampleFactory instance;

    private SampleFactory() {
    }

    public static SampleFactory getInstance() {
        if (instance == null) {
            instance = new SampleFactory();
        }
        return instance;
    }

    public SampleWrapper getSample(SampleIdentifier sampleIdentifier) {
        switch (sampleIdentifier) {
            case CPU_USAGE: {
                SampleWrapper sampleWrapper = new SampleWrapper(new CPUUsageSample());
                sampleWrapper.setColor(new RGB(128, 25, 0));
                sampleWrapper.setCaption("cpuUsage:");
                sampleWrapper.setFormatPattern("%{percentValue}.0f%%");
                return sampleWrapper;
            }
            case HEAP_MEMORY: {
                SampleWrapper sampleWrapper = new SampleWrapper(new HeapMemorySample());
                sampleWrapper.setColor(new RGB(111, 83, 0));
                sampleWrapper.setCaption("heapMemory:");
                sampleWrapper.setFormatPattern("%{value},.2fMB / %{maxValue},.2fMB");
                return sampleWrapper;
            }
            case PHYSICAL_MEMORY: {
                SampleWrapper sampleWrapper = new SampleWrapper(new PhysicalMemorySample());
                sampleWrapper.setColor(new RGB(15, 75, 0));
                sampleWrapper.setCaption("physicalMemory:");
                sampleWrapper.setFormatPattern("%{value},.0fMB / %{maxValue},.0fMB");
                return sampleWrapper;
            }
        }
        SampleWrapper sampleWrapper = new SampleWrapper(new ThreadsUsageSample());
        sampleWrapper.setColor(new RGB(0, 77, 88));
        sampleWrapper.setCaption("threads:");
        sampleWrapper.setFormatPattern("%{value},.0f / %{maxValue},.0f (Peak)");
        return sampleWrapper;
    }
}

