/*
 * Decompiled with CFR 0.152.
 */
package su.artix.artixadmin.connection.manager;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.artixadmin.connection.manager.DataSourceFactory;

public class DataSourceFactoryImpl
implements DataSourceFactory {
    private String driverClass = "com.mysql.cj.jdbc.Driver";
    private static final Logger log = LoggerFactory.getLogger(DataSourceFactoryImpl.class);
    private static final int DEFAULT_CHECKOUT_TIMEOUT = 20000;

    @Override
    public String makeUrl(String ip, String port, String dbName, String user, String password) {
        String url = "${db.prefix.mysql}//${db.ip}:${db.port}/${db.name}$storeId$?user=${user}&password=${password}&useUnicode=true&characterEncoding=UTF-8&zeroDateTimeBehavior=convertToNull&useSSL=false&allowPublicKeyRetrieval=true";
        String prefixMysql = "jdbc:mysql:";
        url = url.replace("${db.prefix.mysql}", prefixMysql).replace("${db.ip}", ip).replace("${db.port}", port).replace("${db.name}", dbName).replace("${user}", user).replace("${password}", password);
        log.trace("created url:{}", (Object)url);
        return url;
    }

    public String makePgUrl(String ip, String port, String dbName, String user, String password) {
        String url = "${db.prefix.mysql}//${db.ip}:5432/documents?user=${user}&password=${password}&useUnicode=true&characterEncoding=UTF-8&zeroDateTimeBehavior=convertToNull";
        String prefixMysql = "jdbc:postgresql:";
        url = url.replace("${db.prefix.mysql}", prefixMysql).replace("${db.ip}", ip).replace("${db.port}", port).replace("${db.name}", dbName).replace("${user}", user).replace("${password}", password);
        log.trace("created url:{}", (Object)url);
        return url;
    }

    @Override
    public DataSource makeDataSource(String user, String password, String ip, String port, String dbName) throws PropertyVetoException {
        return this.makeDataSource(user, password, ip, port, dbName, false);
    }

    @Override
    public DataSource makeDataSource(String user, String password, String ip, String port, String dbName, boolean forSale) throws PropertyVetoException {
        DataSource comboPooledDataSource = forSale && this.isModerSales() ? this.makePgDataSource(user, password, ip, port, dbName) : this.makeMysqlDataSource(user, password, ip, port, dbName);
        return comboPooledDataSource;
    }

    private boolean isModerSales() {
        return Boolean.getBoolean("yuki.modernSale");
    }

    private DataSource makeMysqlDataSource(String user, String password, String ip, String port, String dbName) throws PropertyVetoException {
        ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
        comboPooledDataSource.setDriverClass(this.driverClass);
        comboPooledDataSource.setPreferredTestQuery("select 1");
        comboPooledDataSource.setCheckoutTimeout(Integer.getInteger("yuki.checkout_timeout", 20000).intValue());
        comboPooledDataSource.setTestConnectionOnCheckout(true);
        String preMakeUrl = this.makeUrl(ip, port, dbName, user, password);
        String url = preMakeUrl.replace("$storeId$", "");
        comboPooledDataSource.setJdbcUrl(url);
        return comboPooledDataSource;
    }

    public DataSource makePgDataSource(String user, String password, String ip, String port, String dbName) throws PropertyVetoException {
        ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
        comboPooledDataSource.setDriverClass("org.postgresql.Driver");
        comboPooledDataSource.setPreferredTestQuery("select 1");
        comboPooledDataSource.setCheckoutTimeout(Integer.getInteger("yuki.checkout_timeout", 20000).intValue());
        comboPooledDataSource.setTestConnectionOnCheckout(true);
        String preMakeUrl = this.makePgUrl(ip, port, dbName, user, password);
        String url = preMakeUrl.replace("$storeId$", "");
        comboPooledDataSource.setJdbcUrl(url);
        return comboPooledDataSource;
    }

    @Override
    public boolean resetDataSourceConnections(DataSource dataSource) {
        if (dataSource instanceof ComboPooledDataSource) {
            ((ComboPooledDataSource)dataSource).resetPoolManager(true);
            return true;
        }
        return false;
    }
}

