/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.rest.client.entities;

import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import su.artix.cashserver.core.cashregistry.domain.ShopLabel;
import su.artix.cashserver.rest.client.RestInvoker;
import su.artix.cashserver.rest.client.RestInvokerManager;

public class ShopLabelsRestClient {
    private static final String SHOP_LABEL_URL = "shopLabels";
    private final RestInvokerManager restInvokerManager;

    public ShopLabelsRestClient(RestInvokerManager restInvokerManager) {
        this.restInvokerManager = restInvokerManager;
    }

    public Long countShopLabels() {
        return this.restInvokerManager.getRestInvoker().invokeGet("shopLabels/count", Long.class);
    }

    public Boolean existsShopLabel(String id) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shopLabels/{0}/exists", id), Boolean.class);
    }

    public List<ShopLabel> getShopLabels() {
        ParameterizedTypeReference<List<ShopLabel>> returnTypeRef = new ParameterizedTypeReference<List<ShopLabel>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(SHOP_LABEL_URL, returnTypeRef);
    }

    public List<ShopLabel> getShopLabels(int page, int size) {
        ParameterizedTypeReference<List<ShopLabel>> returnTypeRef = new ParameterizedTypeReference<List<ShopLabel>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet("shopLabels?page=" + page + "&size=" + size, returnTypeRef);
    }

    public List<ShopLabel> getShopLabels(String shopGroupLabelName) {
        ParameterizedTypeReference<List<ShopLabel>> returnTypeRef = new ParameterizedTypeReference<List<ShopLabel>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shopLabels?shopGroupLabel={0}", shopGroupLabelName), returnTypeRef);
    }

    public List<ShopLabel> getShopLabels(String shopGroupLabelName, String clusterId) {
        ParameterizedTypeReference<List<ShopLabel>> returnTypeRef = new ParameterizedTypeReference<List<ShopLabel>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shopLabels?shopGroupLabel={0}&clusterId={1}", shopGroupLabelName, clusterId), returnTypeRef);
    }

    public ShopLabel getShopLabel(String shopLabelCode) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shopLabels/{0}", shopLabelCode), ShopLabel.class);
    }

    public ShopLabel getShopLabelByName(String name) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shopLabels/one?name={0}", name), ShopLabel.class);
    }

    public ShopLabel getShopLabelByNameAndGroup(String name, String group) {
        return this.restInvokerManager.getRestInvoker().invokeGet(RestInvoker.urlBuild("shopLabels/one?name={0}&group={1}", name, group), ShopLabel.class);
    }

    public long countNotSystem() {
        return this.restInvokerManager.getRestInvoker().invokeGet("shopLabels/count?withSystemLabels=false", Long.class);
    }

    public List<ShopLabel> findNotSystem() {
        ParameterizedTypeReference<List<ShopLabel>> returnTypeRef = new ParameterizedTypeReference<List<ShopLabel>>(){};
        return this.restInvokerManager.getRestInvoker().invokeGet("shopLabels?withSystemLabels=false", returnTypeRef);
    }
}

