/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.convert.ConverterRegistration;
import org.springframework.data.mongodb.core.convert.MongoConverters;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomConversions {
    private static final Logger LOG = LoggerFactory.getLogger(CustomConversions.class);
    private static final String READ_CONVERTER_NOT_SIMPLE = "Registering converter from %s to %s as reading converter although it doesn't convert from a Mongo supported type! You might wanna check you annotation setup at the converter implementation.";
    private static final String WRITE_CONVERTER_NOT_SIMPLE = "Registering converter from %s to %s as writing converter although it doesn't convert to a Mongo supported type! You might wanna check you annotation setup at the converter implementation.";
    private final Set<GenericConverter.ConvertiblePair> readingPairs;
    private final Set<GenericConverter.ConvertiblePair> writingPairs;
    private final Set<Class<?>> customSimpleTypes;
    private final SimpleTypeHolder simpleTypeHolder;
    private final List<Object> converters;

    CustomConversions() {
        this(new ArrayList());
    }

    public CustomConversions(List<?> converters) {
        Assert.notNull(converters);
        this.readingPairs = new HashSet<GenericConverter.ConvertiblePair>();
        this.writingPairs = new HashSet<GenericConverter.ConvertiblePair>();
        this.customSimpleTypes = new HashSet();
        this.converters = new ArrayList<Object>();
        this.converters.add((Object)CustomToStringConverter.INSTANCE);
        this.converters.add((Object)MongoConverters.BigDecimalToStringConverter.INSTANCE);
        this.converters.add((Object)MongoConverters.StringToBigDecimalConverter.INSTANCE);
        this.converters.add((Object)MongoConverters.BigIntegerToStringConverter.INSTANCE);
        this.converters.add((Object)MongoConverters.StringToBigIntegerConverter.INSTANCE);
        this.converters.add((Object)MongoConverters.URLToStringConverter.INSTANCE);
        this.converters.add((Object)MongoConverters.StringToURLConverter.INSTANCE);
        this.converters.addAll(converters);
        for (Object c : this.converters) {
            this.registerConversion(c);
        }
        this.simpleTypeHolder = new SimpleTypeHolder(this.customSimpleTypes, MongoSimpleTypes.HOLDER);
    }

    public SimpleTypeHolder getSimpleTypeHolder() {
        return this.simpleTypeHolder;
    }

    public boolean isSimpleType(Class<?> type) {
        return this.simpleTypeHolder.isSimpleType(type);
    }

    public void registerConvertersIn(GenericConversionService conversionService) {
        for (Object converter : this.converters) {
            boolean added = false;
            if (converter instanceof Converter) {
                conversionService.addConverter((Converter)converter);
                added = true;
            }
            if (converter instanceof ConverterFactory) {
                conversionService.addConverterFactory((ConverterFactory)converter);
                added = true;
            }
            if (converter instanceof GenericConverter) {
                conversionService.addConverter((GenericConverter)converter);
                added = true;
            }
            if (added) continue;
            throw new IllegalArgumentException("Given set contains element that is neither Converter nor ConverterFactory!");
        }
    }

    private void registerConversion(Object converter) {
        Class<?> type = converter.getClass();
        boolean isWriting = type.isAnnotationPresent(WritingConverter.class);
        boolean isReading = type.isAnnotationPresent(ReadingConverter.class);
        if (converter instanceof GenericConverter) {
            GenericConverter genericConverter = (GenericConverter)converter;
            for (GenericConverter.ConvertiblePair pair : genericConverter.getConvertibleTypes()) {
                this.register(new ConverterRegistration(pair, isReading, isWriting));
            }
        } else if (converter instanceof Converter) {
            Class[] arguments = GenericTypeResolver.resolveTypeArguments(converter.getClass(), Converter.class);
            this.register(new ConverterRegistration(arguments[0], arguments[1], isReading, isWriting));
        } else {
            throw new IllegalArgumentException("Unsupported Converter type!");
        }
    }

    private void register(ConverterRegistration context) {
        GenericConverter.ConvertiblePair pair = context.getConvertiblePair();
        if (context.isReading()) {
            this.readingPairs.add(pair);
            if (LOG.isWarnEnabled() && !context.isSimpleSourceType()) {
                LOG.warn(String.format(READ_CONVERTER_NOT_SIMPLE, pair.getSourceType(), pair.getTargetType()));
            }
        }
        if (context.isWriting()) {
            this.writingPairs.add(pair);
            this.customSimpleTypes.add(pair.getSourceType());
            if (LOG.isWarnEnabled() && !context.isSimpleTargetType()) {
                LOG.warn(String.format(WRITE_CONVERTER_NOT_SIMPLE, pair.getSourceType(), pair.getTargetType()));
            }
        }
    }

    public Class<?> getCustomWriteTarget(Class<?> source) {
        return this.getCustomWriteTarget(source, null);
    }

    public Class<?> getCustomWriteTarget(Class<?> source, Class<?> expectedTargetType) {
        Assert.notNull(source);
        return CustomConversions.getCustomTarget(source, expectedTargetType, this.writingPairs);
    }

    public boolean hasCustomWriteTarget(Class<?> source) {
        return this.hasCustomWriteTarget(source, null);
    }

    public boolean hasCustomWriteTarget(Class<?> source, Class<?> expectedTargetType) {
        return this.getCustomWriteTarget(source, expectedTargetType) != null;
    }

    public boolean hasCustomReadTarget(Class<?> source, Class<?> expectedTargetType) {
        Assert.notNull(source);
        Assert.notNull(expectedTargetType);
        return CustomConversions.getCustomTarget(source, expectedTargetType, this.readingPairs) != null;
    }

    private static Class<?> getCustomTarget(Class<?> source, Class<?> expectedTargetType, Iterable<GenericConverter.ConvertiblePair> pairs) {
        Assert.notNull(source);
        Assert.notNull(pairs);
        for (GenericConverter.ConvertiblePair typePair : pairs) {
            if (!typePair.getSourceType().isAssignableFrom(source)) continue;
            Class targetType = typePair.getTargetType();
            if (expectedTargetType != null && !targetType.isAssignableFrom(expectedTargetType)) continue;
            return targetType;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @WritingConverter
    private static enum CustomToStringConverter implements GenericConverter
    {
        INSTANCE;


        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            GenericConverter.ConvertiblePair localeToString = new GenericConverter.ConvertiblePair(Locale.class, String.class);
            GenericConverter.ConvertiblePair booleanToString = new GenericConverter.ConvertiblePair(Character.class, String.class);
            return new HashSet<GenericConverter.ConvertiblePair>(Arrays.asList(localeToString, booleanToString));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source.toString();
        }
    }
}

