/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapreduce;

import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByResults<T>
implements Iterable<T> {
    private final List<T> mappedResults;
    private final DBObject rawResults;
    private double count;
    private int keys;
    private String serverUsed;

    public GroupByResults(List<T> mappedResults, DBObject rawResults) {
        Assert.notNull(mappedResults);
        Assert.notNull((Object)rawResults);
        this.mappedResults = mappedResults;
        this.rawResults = rawResults;
        this.parseKeys();
        this.parseCount();
        this.parseServerUsed();
    }

    public double getCount() {
        return this.count;
    }

    public int getKeys() {
        return this.keys;
    }

    public String getServerUsed() {
        return this.serverUsed;
    }

    @Override
    public Iterator<T> iterator() {
        return this.mappedResults.iterator();
    }

    public DBObject getRawResults() {
        return this.rawResults;
    }

    private void parseCount() {
        Object object = this.rawResults.get("count");
        if (object instanceof Double) {
            this.count = (Double)object;
        }
    }

    private void parseKeys() {
        Object object = this.rawResults.get("keys");
        if (object instanceof Integer) {
            this.keys = (Integer)object;
        }
    }

    private void parseServerUsed() {
        Object object = this.rawResults.get("serverUsed");
        if (object instanceof String) {
            this.serverUsed = (String)object;
        }
    }
}

