/*
 * Decompiled with CFR 0.152.
 */
package ru.ssa.artixadmin.editors.directory.action.touch;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.visualization.widgets.datadefinition.IManualValueChangeListener;
import org.eclipse.nebula.visualization.widgets.figures.ScaledSliderFigure;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ssa.artixadmin.editors.directory.action.touch.ActionpanelitemEditDialog;
import ru.ssa.artixadmin.editors.directory.action.touch.DisplayItemContainer;
import ru.ssa.cashadmin.domain.Actionpanel;
import ru.ssa.cashadmin.domain.Actionpanelitem;
import su.artix.yuki.editors.DialogMode;
import su.artix.yuki.model.ModelActivator;
import su.artix.yuki.model.directory.DirectoryEditModel;

public class ActionPanel
extends Composite {
    private static final int SLIDER_STEP = 1;
    private static final Logger log = LoggerFactory.getLogger(ActionPanel.class);
    private Actionpanel actionpanel;
    private Point menuPoint;
    private Point positionPoint;
    MouseMoveListener moveListener;
    MouseMoveListener moveListener2;
    Composite tile;
    ScaledSliderFigure column;
    ScaledSliderFigure row;
    Canvas columnCanvas;
    Canvas rowCanvas;
    final Cursor CURSOR_SIZEN = new Cursor((Device)Display.getDefault(), 10);
    final Cursor CURSOR_SIZENE = new Cursor((Device)Display.getDefault(), 14);
    final Cursor CURSOR_SIZESE = new Cursor((Device)Display.getDefault(), 15);
    final Cursor CURSOR_SIZEE = new Cursor((Device)Display.getDefault(), 12);
    final Cursor CURSOR_SIZES = new Cursor((Device)Display.getDefault(), 11);
    final Cursor CURSOR_SIZESW = new Cursor((Device)Display.getDefault(), 16);
    final Cursor CURSOR_SIZEW = new Cursor((Device)Display.getDefault(), 13);
    final Cursor CURSOR_SIZENW = new Cursor((Device)Display.getDefault(), 17);
    final Cursor CURSOR_ARROW = new Cursor((Device)Display.getDefault(), 0);
    final Cursor CURSOR_CROSS = new Cursor((Device)Display.getDefault(), 2);
    private int resizeStyle;
    private boolean clickAction;
    private boolean move;
    private static int RESIZE_WIDTH = 20;
    private int xDelta;
    private int yDelta;
    DisplayItemContainer container;
    List<Actionpanelitem> original;
    private DisplayItemContainer.DisplayItem selected;
    private Rectangle currentRectangle;

    public ActionPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        new Label((Composite)this, 0);
        Button ok = new Button((Composite)this, 8);
        ok.setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        ok.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        ok.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ActionPanel.this.doSaveWithValidate();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        new Label((Composite)this, 0);
        this.columnCanvas = new Canvas((Composite)this, 0);
        GridData c = new GridData(4, 0, true, false);
        c.heightHint = 80;
        this.columnCanvas.setLayoutData((Object)c);
        LightweightSystem columnws = new LightweightSystem(this.columnCanvas);
        this.column = new ScaledSliderFigure();
        this.column.setRange(1.0, 20.0);
        this.column.setHorizontal(true);
        this.column.setShowLolo(false);
        this.column.setShowMinorTicks(false);
        this.column.getScale().setMajorGridStep(1.0);
        columnws.setContents((IFigure)this.column);
        this.column.addManualValueChangeListener(new IManualValueChangeListener(){

            public void manualValueChanged(double sel) {
                ActionPanel.this.positionPoint = null;
                ActionPanel.this.actionpanel.setColumncount(Integer.valueOf((int)sel / 1));
                ActionPanel.this.fillRect();
                ActionPanel.this.resizeButtons();
                ActionPanel.this.tile.redraw();
            }
        });
        this.rowCanvas = new Canvas((Composite)this, 0);
        GridData r = new GridData(0, 4, false, true);
        r.widthHint = 80;
        this.rowCanvas.setLayoutData((Object)r);
        LightweightSystem rowws = new LightweightSystem(this.rowCanvas);
        this.row = new ScaledSliderFigure();
        this.row.setRange(1.0, 6.0);
        this.row.setShowLolo(false);
        this.row.setShowMinorTicks(false);
        this.row.getScale().setMajorGridStep(1.0);
        this.row.addManualValueChangeListener(new IManualValueChangeListener(){

            public void manualValueChanged(double sel) {
                ActionPanel.this.positionPoint = null;
                ActionPanel.this.actionpanel.setRowcount(Integer.valueOf((int)sel / 1));
                ActionPanel.this.fillRect();
                ActionPanel.this.resizeButtons();
                ActionPanel.this.tile.redraw();
            }
        });
        rowws.setContents((IFigure)this.row);
        this.tile = new Composite((Composite)this, 0);
        this.tile.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (ActionPanel.this.actionpanel != null) {
                    ActionPanel.this.fillRect();
                    ActionPanel.this.resizeButtons();
                    ActionPanel.this.tile.redraw();
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 300;
        this.tile.setLayoutData((Object)gd);
        this.moveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Rectangle bounds = ((Control)e.getSource()).getBounds();
                ActionPanel.this.positionPoint = new Point(e.x + bounds.x, e.y + bounds.y);
                ActionPanel.this.tile.redraw();
            }
        };
        this.moveListener2 = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                ActionPanel.this.positionPoint = new Point(e.x, e.y);
                ActionPanel.this.tile.redraw();
            }
        };
        this.tile.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ActionPanel.this.actionpanel != null) {
                    int column = ActionPanel.this.actionpanel.getColumncount();
                    int row = ActionPanel.this.actionpanel.getRowcount();
                    int j = 0;
                    while (j < row) {
                        int i = 0;
                        while (i < column) {
                            DisplayItemContainer.DisplayItem item = ActionPanel.this.container.get(i + 1, j + 1);
                            if (item.getRectangle() != null) {
                                if (ActionPanel.this.positionPoint != null && item.getRectangle().contains(ActionPanel.this.positionPoint)) {
                                    if (ActionPanel.this.clickAction) {
                                        DisplayItemContainer.DisplayItem underCursor = ActionPanel.this.container.findNotStubWithSpan(((ActionPanel)ActionPanel.this).positionPoint.x, ((ActionPanel)ActionPanel.this).positionPoint.y);
                                        if (underCursor == null || underCursor.equals(ActionPanel.this.selected)) {
                                            e.gc.setBackground(new Color((Device)Display.getDefault(), new RGB(0, 255, 0)));
                                        } else {
                                            e.gc.setBackground(new Color((Device)Display.getDefault(), new RGB(255, 0, 0)));
                                        }
                                    } else {
                                        e.gc.setBackground(new Color((Device)Display.getDefault(), new RGB(170, 25, 168)));
                                    }
                                } else if (ActionPanel.this.clickAction && ActionPanel.this.selected != null && !ActionPanel.this.selected.equals(item) && ActionPanel.this.container.intersects(item, ActionPanel.this.currentRectangle, false)) {
                                    e.gc.setBackground(new Color((Device)Display.getDefault(), new RGB(255, 0, 0)));
                                } else {
                                    e.gc.setBackground(new Color((Device)Display.getDefault(), new RGB(Math.max(255 - (i + 1) * (j + 1) * 10, 0), 255, Math.max(255 - (i + 1) * (j + 1) * 10, 0))));
                                }
                                e.gc.fillRectangle(item.getRectangle());
                                e.gc.drawString(item.getItemName(), item.getRectangle().x + 20, item.getRectangle().y + 20);
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        });
        this.tile.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    ActionPanel.this.menuPoint = new Point(e.x, e.y);
                }
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.tile.addMouseMoveListener(this.moveListener2);
        Menu menu = new Menu((Control)this);
        this.tile.setMenu(menu);
        MenuItem mntmProperties = new MenuItem(menu, 0);
        mntmProperties.setText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
        mntmProperties.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button b;
                Actionpanelitem actionpanelitem;
                DisplayItemContainer.DisplayItem item = ActionPanel.this.container.find(((ActionPanel)ActionPanel.this).menuPoint.x, ((ActionPanel)ActionPanel.this).menuPoint.y);
                if (item != null && (actionpanelitem = ActionPanel.this.openEditDilog(item.getData())) != null && (b = ActionPanel.this.createButton(item)) != null) {
                    ActionPanel.this.updateButton(b, actionpanelitem);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    public boolean isValid() {
        boolean result = true;
        int column = this.actionpanel.getColumncount();
        int row = this.actionpanel.getRowcount();
        List<Actionpanelitem> items = this.container.getNormal();
        for (Actionpanelitem item : items) {
            if (item.getColumn() > column || item.getRow() > row) {
                return false;
            }
            if (item.getColumnspan() != null && item.getColumn() + item.getColumnspan() - 1 > column) {
                return false;
            }
            if (item.getRowspan() == null || item.getRow() + item.getRowspan() - 1 <= row) continue;
            return false;
        }
        return result;
    }

    public boolean openConfirmDilog() {
        MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f?", null, "\u0412\u044b \u043f\u043e\u043a\u0438\u0434\u0430\u0435\u0442\u0435 \u043e\u043a\u043d\u043e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f touch \u043c\u0435\u043d\u044e.\n\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f?", 3, new String[]{"\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", "\u041d\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c", "\u041e\u0442\u043c\u0435\u043d\u0430"}, 0);
        int resultCode = dialog.open();
        boolean result = true;
        switch (resultCode) {
            case 0: {
                result = this.doSaveWithValidate();
                break;
            }
            case 1: {
                result = true;
                this.original = null;
                break;
            }
            case 2: {
                result = false;
                break;
            }
        }
        log.trace("dialog result code: {},result={}", (Object)resultCode, (Object)result);
        return result;
    }

    public boolean isChanged() {
        if (this.container != null) {
            List<Actionpanelitem> items = this.container.getNormal();
            boolean result = this.original != null && (this.original.size() != items.size() || !this.original.containsAll(items));
            log.info("is changed={}", (Object)result);
            log.info("original={}", this.original);
            log.info("new item={}", items);
            return result;
        }
        return false;
    }

    public boolean doSave() {
        try {
            DirectoryEditModel itemModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Actionpanelitem.class);
            Integer id = (Integer)itemModel.getNextId();
            List<Actionpanelitem> items = this.container.getNormal();
            for (Actionpanelitem item : items) {
                log.info("item={}", (Object)item);
                if (item.getActionpanelitemcode() == null) {
                    Integer n = id;
                    id = n + 1;
                    item.setActionpanelitemcode(n);
                }
                item.setActionpanelcode(this.actionpanel.getActionpanelcode());
            }
            List removeItems = (List)CollectionUtils.subtract(this.original, items);
            log.info("items for remove={}", (Object)removeItems);
            itemModel.doRemoveAll((Collection)removeItems);
            this.original = items;
            itemModel.saveCollection(items);
            DirectoryEditModel panelModel = ModelActivator.getDefault().getModelProvider().getDirectoryModel(Actionpanel.class);
            this.actionpanel.setItemCollection(null);
            panelModel.doUpdate((Object)this.actionpanel);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void fillMatrix(Actionpanel actionpanel, List<Actionpanelitem> items) {
        this.container = new DisplayItemContainer(actionpanel, items){

            @Override
            protected Actionpanelitem getNewActionpanelitem(Actionpanel actionpanel) {
                return ActionPanel.this.getNewActionpanelitem(actionpanel);
            }
        };
        this.original = items;
        this.fillRect();
    }

    protected Actionpanelitem getNewActionpanelitem(Actionpanel parent) {
        return new Actionpanelitem();
    }

    public void fillButtons() {
        int column = this.actionpanel.getColumncount();
        int row = this.actionpanel.getRowcount();
        int j = 0;
        while (j < row) {
            int i = 0;
            while (i < column) {
                DisplayItemContainer.DisplayItem item = this.container.get(i + 1, j + 1);
                if (item != null && !item.isStub()) {
                    this.createButton(item);
                }
                ++i;
            }
            ++j;
        }
    }

    public void fillRect() {
        this.container.fillRect(this.tile.getBounds(), this.actionpanel.getColumncount(), this.actionpanel.getRowcount());
    }

    public void resizeButtons() {
        int column = this.actionpanel.getColumncount();
        int row = this.actionpanel.getRowcount();
        Control[] controlArray = this.tile.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control con = controlArray[n2];
            Object conData = con.getData();
            if (conData != null && conData instanceof DisplayItemContainer.DisplayItem) {
                DisplayItemContainer.DisplayItem item = (DisplayItemContainer.DisplayItem)conData;
                con.setBounds(item.getRectangleForButton());
                if (item.getData().getRow() != null && item.getData().getRow() <= row && item.getData().getColumn() != null && item.getData().getColumn() <= column) {
                    con.setVisible(true);
                } else {
                    con.setVisible(false);
                }
            }
            ++n2;
        }
    }

    public void initialize() {
        this.column.manualSetValue((double)this.actionpanel.getColumncount().intValue());
        this.row.manualSetValue((double)this.actionpanel.getRowcount().intValue());
    }

    public Actionpanel getActionpanel() {
        return this.actionpanel;
    }

    public void setActionpanel(Actionpanel actionpanel) {
        this.actionpanel = actionpanel;
    }

    private Button createButton(DisplayItemContainer.DisplayItem item) {
        Button result = null;
        if (item != null) {
            Button b;
            result = b = new Button(this.tile, 8);
            item.setStub(false);
            b.setData((Object)item);
            b.setText(item.getItemName());
            b.setBackground(item.getBackground());
            b.setForeground(item.getForeground());
            b.setBounds(item.getRectangleForButton());
            b.addMouseMoveListener(this.moveListener);
            b.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            b.addMouseMoveListener(new MouseMoveListener(){

                public boolean contains(int x, int y, int zx, int zy, int width, int height) {
                    return x >= zx && y >= zy && x < zx + width && y < zy + height;
                }

                public void mouseMove(MouseEvent event) {
                    int height = ((Button)event.getSource()).getBounds().height;
                    int width = ((Button)event.getSource()).getBounds().width;
                    if (this.contains(event.x, event.y, 0, 0, RESIZE_WIDTH, RESIZE_WIDTH)) {
                        b.setCursor(ActionPanel.this.CURSOR_SIZENW);
                        if (!ActionPanel.this.clickAction) {
                            ActionPanel.this.resizeStyle = 16512;
                            ActionPanel.this.move = false;
                        }
                    } else if (this.contains(event.x, event.y, width - RESIZE_WIDTH, 0, RESIZE_WIDTH, RESIZE_WIDTH)) {
                        b.setCursor(ActionPanel.this.CURSOR_SIZENE);
                        if (!ActionPanel.this.clickAction) {
                            ActionPanel.this.resizeStyle = 131200;
                            ActionPanel.this.move = false;
                        }
                    } else if (this.contains(event.x, event.y, 0, height - RESIZE_WIDTH, RESIZE_WIDTH, RESIZE_WIDTH)) {
                        b.setCursor(ActionPanel.this.CURSOR_SIZESW);
                        if (!ActionPanel.this.clickAction) {
                            ActionPanel.this.resizeStyle = 17408;
                            ActionPanel.this.move = false;
                        }
                    } else if (this.contains(event.x, event.y, width - RESIZE_WIDTH, height - RESIZE_WIDTH, RESIZE_WIDTH, RESIZE_WIDTH)) {
                        b.setCursor(ActionPanel.this.CURSOR_SIZESE);
                        if (!ActionPanel.this.clickAction) {
                            ActionPanel.this.resizeStyle = 132096;
                            ActionPanel.this.move = false;
                        }
                    } else if (this.contains(event.x, event.y, RESIZE_WIDTH, 0, width - 2 * RESIZE_WIDTH, RESIZE_WIDTH)) {
                        b.setCursor(ActionPanel.this.CURSOR_SIZEN);
                        if (!ActionPanel.this.clickAction) {
                            ActionPanel.this.resizeStyle = 128;
                            ActionPanel.this.move = false;
                        }
                    } else if (this.contains(event.x, event.y, width - RESIZE_WIDTH, RESIZE_WIDTH, RESIZE_WIDTH, height - 2 * RESIZE_WIDTH)) {
                        b.setCursor(ActionPanel.this.CURSOR_SIZEE);
                        if (!ActionPanel.this.clickAction) {
                            ActionPanel.this.resizeStyle = 131072;
                            ActionPanel.this.move = false;
                        }
                    } else if (this.contains(event.x, event.y, RESIZE_WIDTH, height - RESIZE_WIDTH, width - 2 * RESIZE_WIDTH, RESIZE_WIDTH)) {
                        b.setCursor(ActionPanel.this.CURSOR_SIZES);
                        if (!ActionPanel.this.clickAction) {
                            ActionPanel.this.resizeStyle = 1024;
                            ActionPanel.this.move = false;
                        }
                    } else if (this.contains(event.x, event.y, 0, RESIZE_WIDTH, RESIZE_WIDTH, height - 2 * RESIZE_WIDTH)) {
                        b.setCursor(ActionPanel.this.CURSOR_SIZEW);
                        if (!ActionPanel.this.clickAction) {
                            ActionPanel.this.resizeStyle = 16384;
                            ActionPanel.this.move = false;
                        }
                    } else if (!ActionPanel.this.clickAction) {
                        b.setCursor(ActionPanel.this.CURSOR_CROSS);
                        ActionPanel.this.move = true;
                        ActionPanel.this.resizeStyle = 0;
                    }
                    if (ActionPanel.this.clickAction) {
                        Rectangle rect = b.getBounds();
                        int newWidth = width;
                        int newHeight = height;
                        int x = b.getLocation().x;
                        int y = b.getLocation().y;
                        if ((ActionPanel.this.resizeStyle & 0x20000) != 0) {
                            newWidth = rect.width + (event.x - rect.width);
                        }
                        if ((ActionPanel.this.resizeStyle & 0x400) != 0) {
                            newHeight = rect.height + (event.y - rect.height);
                        }
                        if ((ActionPanel.this.resizeStyle & 0x80) != 0) {
                            y += event.y;
                            newHeight = rect.height - event.y;
                        }
                        if ((ActionPanel.this.resizeStyle & 0x4000) != 0) {
                            x += event.x;
                            newWidth = rect.width - event.x;
                        }
                        if (ActionPanel.this.move) {
                            x = x + event.x - ActionPanel.this.xDelta;
                            y = y + event.y - ActionPanel.this.yDelta;
                        }
                        b.setSize(Math.max(newWidth, 20), Math.max(newHeight, 20));
                        b.setLocation(x, y);
                        ActionPanel.this.currentRectangle = b.getBounds();
                    }
                }
            });
            b.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    ActionPanel.this.clickAction = false;
                    ActionPanel.this.resizeStyle = 0;
                    DisplayItemContainer.DisplayItem item = (DisplayItemContainer.DisplayItem)b.getData();
                    boolean cross = false;
                    DisplayItemContainer.DisplayItem newLocation = ActionPanel.this.move ? ActionPanel.this.container.find(b.getLocation().x + e.x, b.getLocation().y + e.y) : ActionPanel.this.container.find(b.getLocation().x, b.getLocation().y);
                    DisplayItemContainer.DisplayItem underCursorWithSpan = ActionPanel.this.container.findWithSpan(b.getLocation().x + e.x, b.getLocation().y + e.y);
                    cross = true;
                    if (underCursorWithSpan.isStub()) {
                        log.trace("stub object CAN");
                        cross = false;
                    }
                    if (underCursorWithSpan.equals(item)) {
                        log.trace("same object CAN");
                        cross = false;
                    }
                    if (ActionPanel.this.container.intersects(item, ActionPanel.this.currentRectangle, true)) {
                        cross = true;
                        log.trace("detect cross NOT {}", (Object)ActionPanel.this.container.intersects(item, ActionPanel.this.currentRectangle, true));
                    }
                    if (newLocation == null) {
                        log.error("couldn't find new location");
                    } else if (!cross) {
                        ActionPanel.this.container.move(item, newLocation);
                    }
                    if (!cross) {
                        item.recalculateSpan(b.getBounds().width, b.getBounds().height);
                    }
                    b.setBounds(item.getRectangleForButton());
                    ActionPanel.this.selected = null;
                    ActionPanel.this.currentRectangle = null;
                }

                public void mouseDown(MouseEvent event) {
                    if (ActionPanel.this.resizeStyle > 0 || ActionPanel.this.move) {
                        log.trace("begin resize, resizeStyle={}", (Object)ActionPanel.this.resizeStyle);
                        ActionPanel.this.clickAction = true;
                        ActionPanel.this.yDelta = event.y;
                        ActionPanel.this.xDelta = event.x;
                        ActionPanel.this.selected = (DisplayItemContainer.DisplayItem)b.getData();
                    }
                }

                public void mouseDoubleClick(MouseEvent arg0) {
                }
            });
            Menu menu = new Menu((Control)b);
            b.setMenu(menu);
            MenuItem delItem = new MenuItem(menu, 0);
            delItem.setText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
            delItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    ActionPanel.this.container.fillStubElement((DisplayItemContainer.DisplayItem)b.getData());
                    b.dispose();
                    ActionPanel.this.resetEdit();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            MenuItem editItem = new MenuItem(menu, 0);
            editItem.setText("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
            editItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    ActionPanel.this.editButtonAction(b);
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
        }
        return result;
    }

    protected Actionpanelitem openEditDilog(Actionpanelitem obj) {
        ActionpanelitemEditDialog dialog = new ActionpanelitemEditDialog(Display.getDefault().getActiveShell(), obj, DialogMode.CREATE);
        dialog.setApplayButtonVisisble(false);
        if (dialog.open() == 0) {
            Actionpanelitem after = (Actionpanelitem)dialog.getActualModel();
            after.setActionpanelitemcode(obj.getActionpanelitemcode());
            return after;
        }
        return null;
    }

    public Composite getTile() {
        return this.tile;
    }

    public void setTile(Composite tile) {
        this.tile = tile;
    }

    public void resetEdit() {
        this.clickAction = false;
        this.move = false;
        this.resizeStyle = 0;
    }

    private void updateButton(Button b, Actionpanelitem afterEdit) {
        DisplayItemContainer.DisplayItem item = (DisplayItemContainer.DisplayItem)b.getData();
        item.setData(afterEdit);
        b.setText(item.getItemName());
        b.setBackground(item.getBackground());
        b.setForeground(item.getForeground());
    }

    private void editButtonAction(Button b) {
        this.resetEdit();
        Actionpanelitem afterEdit = this.openEditDilog(((DisplayItemContainer.DisplayItem)b.getData()).getData());
        if (afterEdit != null) {
            this.updateButton(b, afterEdit);
        }
    }

    private boolean doSaveWithValidate() {
        if (this.isValid()) {
            if (this.doSave()) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f", (String)"\u0414\u0430\u043d\u043d\u044b\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b.");
                return true;
            }
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430", (String)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435, \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438");
            return false;
        }
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"\u041e\u0448\u0438\u0431\u043a\u0430", (String)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435, \u043a\u043d\u043e\u043f\u043a\u0438 \u0432\u044b\u0445\u043e\u0434\u044f\u0442 \u0437\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u043f\u0430\u043d\u0435\u043b\u0438");
        return false;
    }
}

