/*
 * Decompiled with CFR 0.152.
 */
package su.artix.cashserver.core.cashregistry.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import su.artix.cashserver.core.cashregistry.domain.Categoriable;
import su.artix.cashserver.core.cashregistry.domain.Category;
import su.artix.cashserver.core.cashregistry.domain.IParentObject;
import su.artix.cashserver.core.cashregistry.domain.IServerObject;
import su.artix.cashserver.core.cashregistry.domain.ShopLabel;
import su.artix.cashserver.core.cashregistry.domain.Tag;
import su.artix.cashserver.core.cashregistry.domain.Unloadable;

@Document(collection="shop")
public class Shop
implements Serializable,
IServerObject,
IParentObject,
Unloadable,
Categoriable {
    private static final long serialVersionUID = 1L;
    @Id
    private String code;
    @DBRef
    private IParentObject parent;
    @DBRef(db="tag")
    private List<Tag> tags = new ArrayList<Tag>();
    @DBRef(db="shopLabel")
    private List<ShopLabel> shopLabels = new ArrayList<ShopLabel>();
    @DBRef(db="category")
    private List<Category> categories = new ArrayList<Category>();
    private String extendedOptions;
    private String title;
    private String clusterId;
    private String displayCode;
    private String cashserverId;
    @Transient
    private Boolean hasChildren;
    private String kppExcise;
    private String fsrarIdExcise;
    private String kppNonExcise;
    private String fsrarIdNonExcise;
    private boolean equalsExciseAndNonExcise;
    private String address;

    public IParentObject getParent() {
        return this.parent;
    }

    public void setParent(IParentObject parent) {
        this.parent = parent;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String shopCode) {
        this.code = shopCode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Shop other = (Shop)obj;
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }

    @Override
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public List<Tag> getTags() {
        return this.tags;
    }

    @Override
    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return "";
    }

    public String toString() {
        return "ShopImpl [code=" + this.code + "]";
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getExtendedOptions() {
        return this.extendedOptions;
    }

    public void setExtendedOptions(String extendedOptions) {
        this.extendedOptions = extendedOptions;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public String getDisplayCode() {
        return this.displayCode;
    }

    public void setDisplayCode(String displayCode) {
        this.displayCode = displayCode;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    @Override
    public List<Category> getCategories() {
        return this.categories;
    }

    public void setShopLabels(List<ShopLabel> shopLabels) {
        this.shopLabels = shopLabels;
    }

    public List<ShopLabel> getShopLabels() {
        return this.shopLabels;
    }

    public void setCashserverId(String cashserverId) {
        this.cashserverId = cashserverId;
    }

    @Override
    public String getCashserverId() {
        return this.cashserverId;
    }

    @Override
    public Boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(Boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public String getKppExcise() {
        return this.kppExcise;
    }

    public void setKppExcise(String kppExcise) {
        this.kppExcise = kppExcise;
    }

    public String getFsrarIdExcise() {
        return this.fsrarIdExcise;
    }

    public void setFsrarIdExcise(String fsrarIdExcise) {
        this.fsrarIdExcise = fsrarIdExcise;
    }

    public String getKppNonExcise() {
        return this.kppNonExcise;
    }

    public void setKppNonExcise(String kppNonExcise) {
        this.kppNonExcise = kppNonExcise;
    }

    public String getFsrarIdNonExcise() {
        return this.fsrarIdNonExcise;
    }

    public void setFsrarIdNonExcise(String fsrarIdNonExcise) {
        this.fsrarIdNonExcise = fsrarIdNonExcise;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isEqualsExciseAndNonExcise() {
        return this.equalsExciseAndNonExcise;
    }

    public void setEqualsExciseAndNonExcise(boolean equalsExciseAndNonExcise) {
        this.equalsExciseAndNonExcise = equalsExciseAndNonExcise;
    }
}

